<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Front\FrontController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\Admin\AdminUserController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\HeroSliderController;
use App\Http\Controllers\UserAdmin\AuthController as UserAdminAuth;
use App\Http\Controllers\UserAdmin\DashboardController as UserAdminDashboard;
use App\Http\Controllers\Admin\ExclusiveSectionController;
use App\Http\Controllers\Admin\AboutSectionController;
use App\Http\Controllers\Admin\AboutCreativityController;
use App\Http\Controllers\Admin\ContactEnquiryController;
use App\Http\Controllers\Admin\ContactSettingController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\MediaPresenceController;
use App\Http\Controllers\Admin\PageContentController;
use App\Http\Controllers\Admin\ArtAdvisoryController;
use App\Http\Controllers\Artist\PaintingController as ArtistPaintingController;
use App\Http\Controllers\Artist\ProfileController as ArtistProfileController;
use App\Http\Controllers\Artist\AuthController as ArtistAuth;
use App\Http\Controllers\Artist\DashboardController as ArtistDashboard;
use App\Http\Controllers\FrontBlogController;
use App\Http\Controllers\Front\PaintingController;
use App\Http\Controllers\FavouriteController;
use App\Http\Controllers\Front\SculptureController;
use App\Http\Controllers\Front\ArtworkEnquiryController;
use App\Http\Controllers\ArtworkController;
use App\Http\Controllers\Front\PageController as DynamicPageController;



Route::post(
    '/artwork-enquiry',
    [ArtworkEnquiryController::class, 'store']
)->name('artwork.enquiry.store');


// Artist routes
Route::prefix('artist')->group(function () {
    // Auth routes (no middleware)
    Route::get('/login', [ArtistAuth::class, 'login'])->name('artist.login');
    Route::post('/login', [ArtistAuth::class, 'login_submit'])->name('artist.login_submit');

    // Protected routes
    Route::middleware('artist')->group(function () {
        Route::get('/dashboard', [ArtistDashboard::class, 'index'])->name('artist.dashboard');
        Route::get('/logout', [ArtistAuth::class, 'logout'])->name('artist.logout');
        Route::get('/profile', [ArtistProfileController::class, 'edit'])->name('artist.profile');
        Route::post('/profile', [ArtistProfileController::class, 'update'])->name('artist.profile.update');
        Route::get('/change-password', [ArtistProfileController::class, 'changePassword'])->name('artist.password');
        Route::post('/change-password', [ArtistProfileController::class, 'updatePassword'])->name('artist.password.update');
        Route::resource('paintings', ArtistPaintingController::class)->names('artist.paintings');
    });
});

// Front-end routes
Route::post('/artist-enquiry', [ArtworkEnquiryController::class, 'artistEnquiry'])
     ->name('artist.enquiry.store');
Route::post('/contact-submit', [FrontController::class, 'contactSubmit'])->name('contact.submit');
Route::get('/exhibitions/{slug}', [FrontController::class, 'exhibitionDetail'])->name('exhibitions.show');
Route::get('/category/{slug}', [FrontController::class, 'categoryPage'])->name('front.category');
Route::get('/sculptures', [SculptureController::class, 'index'])->name('sculptures.index');
Route::get('/sculpture/{id}', [SculptureController::class, 'show'])->name('sculpture.show');
Route::get('/artworks/form/{slug}', [PaintingController::class, 'index'])->name('artworks.form');
Route::get('/artworks/{slug}', [ArtworkController::class, 'show'])->name('artworks.show');
Route::get('/blogs/category/{slug}', [FrontBlogController::class, 'category'])->name('blogs.category');
Route::get('/blogs/{slug}', [FrontBlogController::class, 'show'])->name('blogs.show');
Route::get('/artist/{slug}', [App\Http\Controllers\Front\ArtistController::class, 'show'])->name('artist.detail');
Route::get('/event/{slug}', [App\Http\Controllers\Admin\EventController::class, 'show'])->name('event.detail');

// Authenticated user routes
Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [UserController::class, 'dashboard'])->name('dashboard');
    Route::get('/profile', [UserController::class, 'profile'])->name('profile');
    Route::post('/profile', [UserController::class, 'profile_submit'])->name('profile_submit');
    Route::get('/favourite/{painting}', [FavouriteController::class, 'toggle'])->name('favourite.toggle');
    Route::get('/my-favourites', [FavouriteController::class, 'myFavourites'])->name('my.favourites');
});

// User auth routes (no middleware)
Route::get('/registration', [UserController::class, 'registration'])->name('registration');
Route::post('/registration', [UserController::class, 'registration_submit'])->name('registration_submit');
Route::get('/registration-verify/{token}/{email}', [UserController::class, 'registration_verify'])->name('registration_verify');
Route::get('/login', [UserController::class, 'login'])->name('login');
Route::post('/login', [UserController::class, 'login_submit'])->name('login_submit');
Route::get('/forget-password', [UserController::class, 'forget_password'])->name('forget_password');
Route::post('/forget-password', [UserController::class, 'forget_password_submit'])->name('forget_password_submit');
Route::get('/reset-password/{token}/{email}', [UserController::class, 'reset_password'])->name('reset_password');
Route::post('/reset-password/{token}/{email}', [UserController::class, 'reset_password_submit'])->name('reset_password_submit');
Route::post('/logout', [UserController::class, 'logout'])->name('logout');

// Admin routes (merged into one group for cleanliness)
Route::prefix('admin')->middleware('admin')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin_dashboard');
    Route::get('/profile', [AdminController::class, 'profile'])->name('admin_profile');
    Route::post('/profile', [AdminController::class, 'profile_submit'])->name('admin_profile_submit');
    Route::get('/analytics', [AdminController::class, 'analytics'])->name('admin.analytics');

    // Artists
    Route::get('artists/featured', [\App\Http\Controllers\Admin\ArtistController::class, 'featured'])->name('admin.artists.featured');
    Route::match(['get', 'post'], 'artists/bulk-upload', [\App\Http\Controllers\Admin\ArtistController::class, 'bulkUpload'])->name('admin.artists.bulk-upload');
    Route::get('artists/bulk-upload/template', [\App\Http\Controllers\Admin\ArtistController::class, 'downloadBulkTemplate'])->name('admin.artists.bulk-upload.template');
    Route::get('artists/bulk-upload/errors/{token}', [\App\Http\Controllers\Admin\ArtistController::class, 'downloadBulkErrors'])->name('admin.artists.bulk-upload.errors');
    Route::resource('artists', \App\Http\Controllers\Admin\ArtistController::class)->names('admin.artists');
    Route::post('artists/{artist}/toggle-status', [\App\Http\Controllers\Admin\ArtistController::class, 'toggleStatus'])->name('admin.artists.toggleStatus');
    Route::post('artists/{artist}/paintings', [\App\Http\Controllers\Admin\PaintingController::class, 'storeForArtist'])->name('admin.artist.paintings.store');

    // Admin Users
    Route::resource('admin-users', AdminUserController::class)->names('admin.admin-users');
    Route::post('admin-users/{admin_user}/toggle-status', [AdminUserController::class, 'toggleStatus'])->name('admin.admin-users.toggle-status');

    // Categories
    Route::resource('categories', CategoryController::class)->names('admin.categories');

    // Galleries
    Route::resource('galleries', \App\Http\Controllers\Admin\GalleryController::class)->names('admin.galleries');
    Route::post('galleries/{gallery}/toggle-status', [\App\Http\Controllers\Admin\GalleryController::class, 'toggleStatus'])->name('admin.galleries.toggleStatus');

    // Blogs
    Route::resource('blogs', BlogController::class)->names('admin.blogs');
    Route::post('blogs/toggle/{blog}', [BlogController::class, 'toggleStatus'])->name('admin.blogs.toggle');

    // Events
    Route::resource('events', \App\Http\Controllers\Admin\EventController::class)->names('admin.events');
    Route::post('events/{event}/toggle-status', [\App\Http\Controllers\Admin\EventController::class, 'toggleStatus'])->name('admin.events.toggleStatus');

    // Paintings
    Route::resource('paintings', \App\Http\Controllers\Admin\PaintingController::class)->names('admin.paintings');
    Route::post('paintings/{painting}/toggle-status', [\App\Http\Controllers\Admin\PaintingController::class, 'toggleStatus'])->name('admin.paintings.toggleStatus');
    Route::match(['get', 'post'], 'artworks/bulk-upload', [\App\Http\Controllers\Admin\PaintingController::class, 'bulkUpload'])->name('admin.paintings.bulk-upload');
    Route::get('artworks/bulk-upload/template', [\App\Http\Controllers\Admin\PaintingController::class, 'downloadBulkTemplate'])->name('admin.paintings.bulk-upload.template');
    Route::get('artworks/bulk-upload/errors/{token}', [\App\Http\Controllers\Admin\PaintingController::class, 'downloadBulkErrors'])->name('admin.paintings.bulk-upload.errors');

    // Sculptures
    Route::resource('sculptures', \App\Http\Controllers\Admin\SculptureController::class)->names('admin.sculptures');

    // Blog Categories
    Route::resource('blog-categories', \App\Http\Controllers\Admin\BlogCategoryController::class)->names('admin.blog-categories');

    // Hero Slider
    // Hero Slider
Route::resource('hero', HeroSliderController::class)
    ->names('admin.hero');


    // Exclusive Section
    Route::get('/exclusive', [ExclusiveSectionController::class, 'edit'])->name('admin.exclusive.edit');
    Route::post('/exclusive', [ExclusiveSectionController::class, 'update'])->name('admin.exclusive.update');

    // About Creativity
    Route::get('/about-creativity', [AboutCreativityController::class, 'index'])->name('admin.about-creativity.index');
    Route::post('/about-creativity', [AboutCreativityController::class, 'store'])->name('admin.about-creativity.store');

    // Forms
    Route::resource('forms', \App\Http\Controllers\Admin\FormController::class);

    // Mediums
    Route::get('/mediums', [App\Http\Controllers\Admin\MediumController::class, 'index'])->name('mediums.index');
    Route::post('/mediums', [App\Http\Controllers\Admin\MediumController::class, 'store'])->name('mediums.store');
    Route::put('/mediums/{id}', [App\Http\Controllers\Admin\MediumController::class, 'update'])->name('mediums.update');
    Route::delete('/mediums/{id}', [App\Http\Controllers\Admin\MediumController::class, 'destroy'])->name('mediums.destroy');

    // About Section
    Route::get('/about', [AboutSectionController::class, 'edit'])->name('admin.about.edit');
    Route::post('/about', [AboutSectionController::class, 'update'])->name('admin.about.update');

    // Artwork Types
    Route::resource('artwork-types', \App\Http\Controllers\Admin\ArtworkTypeController::class)->names('admin.artwork-types')->except(['create', 'edit', 'show']);

    // Exhibitions
    Route::resource('/exhibitions', \App\Http\Controllers\Admin\ExhibitionController::class)->names('admin.exhibitions');
    Route::delete('exhibition-images/{image}', [App\Http\Controllers\Admin\ExhibitionImageController::class, 'destroy'])->name('admin.exhibition-images.destroy');

    // Contact Enquiries
    Route::get('contact-enquiries', [ContactEnquiryController::class, 'index'])->name('admin.contact.index');
    Route::get('contact-enquiries/notifications/latest', [ContactEnquiryController::class, 'latest'])->name('admin.contact.notifications.latest');
    Route::get('contact-enquiries/{contactEnquiry}', [ContactEnquiryController::class, 'show'])->name('admin.contact.show');

    // Contact Settings
    Route::get('/contact-settings', [ContactSettingController::class, 'edit'])->name('admin.contact.settings');
    Route::post('/contact-settings', [ContactSettingController::class, 'update'])->name('admin.contact.settings.update');

    // Testimonials
    Route::resource('testimonials', TestimonialController::class)->names('admin.testimonials');

    // Media Presence
    Route::resource('media', MediaPresenceController::class)->names('admin.media');

    // Page Content
    Route::get('page-content/{page}', [PageContentController::class, 'edit'])->name('admin.page-content.edit');
    Route::post('page-content/{page}', [PageContentController::class, 'update'])->name('admin.page-content.update');

    // SEO Pages
    Route::get('seo-pages', [\App\Http\Controllers\Admin\SeoPageController::class, 'index'])->name('admin.seo-pages.index');
    Route::get('seo-pages/{key}/edit', [\App\Http\Controllers\Admin\SeoPageController::class, 'edit'])->name('admin.seo-pages.edit');
    Route::put('seo-pages/{key}', [\App\Http\Controllers\Admin\SeoPageController::class, 'update'])->name('admin.seo-pages.update');

    // Art Advisory
    Route::get('art-advisory', [ArtAdvisoryController::class, 'edit'])->name('admin.art-advisory.edit');
    Route::post('art-advisory', [ArtAdvisoryController::class, 'update'])->name('admin.art-advisory.update');

    // Footer
    Route::get('/footer', [\App\Http\Controllers\Admin\FooterController::class, 'edit'])->name('admin.footer.edit');
    Route::post('/footer', [\App\Http\Controllers\Admin\FooterController::class, 'update'])->name('admin.footer.update');

    // Popular Searches
  Route::resource('popular-searches', \App\Http\Controllers\Admin\PopularSearchController::class)
    ->names('admin.popular-searches')
    ->except(['show']);
});

// Admin auth routes (no middleware)
Route::prefix('admin')->group(function () {
    Route::get('/', function () { return redirect()->route('admin_login'); });
    Route::get('/login', [AdminController::class, 'login'])->name('admin_login');
    Route::post('/login', [AdminController::class, 'login_submit'])->name('admin_login_submit');
    Route::get('/forget-password', [AdminController::class, 'forget_password'])->name('admin_forget_password');
    Route::post('/forget-password', [AdminController::class, 'forget_password_submit'])->name('admin_forget_password_submit');
    Route::get('/reset-password/{token}/{email}', [AdminController::class, 'reset_password'])->name('admin_reset_password');
    Route::post('/reset-password/{token}/{email}', [AdminController::class, 'reset_password_submit'])->name('admin_reset_password_submit');
    Route::get('/logout', [AdminController::class, 'logout'])->name('admin_logout');
});

// Sub-admin (User Admin) routes
Route::prefix('admin-user')->group(function () {
    Route::get('/login', [UserAdminAuth::class, 'login'])->name('user_admin.login');
    Route::post('/login', [UserAdminAuth::class, 'login_submit'])->name('user_admin.login_submit');

    Route::middleware('user_admin')->group(function () {
        Route::get('/dashboard', [UserAdminDashboard::class, 'index'])->name('user_admin.dashboard');
        Route::get('/logout', [UserAdminAuth::class, 'logout'])->name('user_admin.logout');
    });
});

// Dynamic CMS/SEO pages (keep this at the end to avoid conflicts)
Route::get('/', [DynamicPageController::class, 'show'])->name('home');
Route::get('/{slug}', [DynamicPageController::class, 'show'])
    ->where('slug', '[A-Za-z0-9\-]+')
    ->name('pages.show');
