<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title><?php echo e($seoMeta->seo_title ?? trim($__env->yieldContent('title', 'Creativity Art Gallery'))); ?></title>
    <meta name="description" content="<?php echo e($seoMeta->meta_description ?? trim($__env->yieldContent('meta_description', ''))); ?>">
    <meta name="keywords" content="<?php echo e($seoMeta->meta_keywords ?? trim($__env->yieldContent('meta_keywords', ''))); ?>">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" defer></script>

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">

    <style>
        @media (max-width: 991px) {
    .navbar-artworks .artwork-dropdown {
        position: static;
        box-shadow: none;
        display: none;
        margin-top: 6px;
    }
}

      /* FAVOURITE ICON */
.fav-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: 1px solid #ddd;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #2e2724;
    text-decoration: none;
    position: relative;
    background: #fff;
}

.fav-icon:hover {
    background: #f6f6f6;
}

.fav-icon i {
    font-size: 16px;
}

/* COUNT BADGE */
.fav-count {
    position: absolute;
    top: -4px;
    right: -4px;
    background: #c0392b;
    color: #fff;
    font-size: 11px;
    padding: 2px 6px;
    border-radius: 50%;
    font-weight: 600;
}

      /* USER MENU */
.user-menu {
    position: relative;
}

.user-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: 1px solid #ddd;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    background: #fff;
}

.user-icon i {
    font-size: 16px;
}

.user-dropdown {
    position: absolute;
    right: 0;
    top: 50px;
    width: 180px;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    display: none;
    overflow: hidden;
    z-index: 9999;
}

.user-dropdown a,
.user-dropdown button {
    display: block;
    width: 100%;
    padding: 10px 14px;
    text-align: left;
    background: none;
    border: none;
    font-weight: 500;
    color: #2e2724;
    text-decoration: none;
}

.user-dropdown a:hover,
.user-dropdown button:hover {
    background: #f6f6f6;
}

.logout-btn {
    color: #c0392b;
}

/* SHOW ON HOVER (DESKTOP) */
@media (min-width: 992px) {
    .user-menu:hover .user-dropdown {
        display: block;
    }
}

/* ===== Search & Currency ===== */
.header-tools {
    display: flex;
    align-items: center;
    gap: 14px;
}

/* Search */
.search-toggle {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: 1px solid #ddd;
    background: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
}

.search-box {
    position: absolute;
    top: 60px;
    right: 0;
    background: #fff;
    width: 260px;
    padding: 12px;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    display: none;
    z-index: 9999;
}

.search-box input {
    width: 100%;
    border-radius: 30px;
    padding: 8px 14px;
    border: 1px solid #ddd;
}

.search-results {
    margin-top: 10px;
    max-height: 200px;
    overflow-y: auto;
}

.search-result-item {
    padding: 8px 0;
    border-bottom: 1px solid #eee;
}

.search-result-item a {
    text-decoration: none;
    color: #2e2724;
}

.search-result-item a:hover {
    color: var(--brand);
}

/* Currency */
.currency-select {
    border-radius: 30px;
    padding: 6px 14px;
    border: 1px solid #ddd;
    font-weight: 600;
    background: #fff;
}
</style>


    <style>
      .navbar-artworks {
    position: relative;
}

.artwork-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    background: #fff;
    min-width: 180px;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.12);
    padding: 8px 0;
    display: none;
    z-index: 9999;
}

.artwork-dropdown a {
    display: block;
    padding: 10px 16px;
    font-weight: 500;
    color: #2e2724;
    text-decoration: none;
}

.artwork-dropdown a:hover {
    background: #f6f6f6;
}

/* Hover trigger */
.navbar-artworks:hover .artwork-dropdown {
    display: block;
}

/* Header buttons */
.header-actions .btn {
    border-radius: 30px;
    padding: 6px 16px;
    font-weight: 600;
}

.fav-btn {
    border-radius: 50%;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
}
      /* .site-header {
    padding-top: 12px;
    padding-bottom: 12px;
} */

.site-header.scrolled {
    padding-top: 6px;
    padding-bottom: 6px;
}

      /* ================= STICKY HEADER FIX ================= */

/* Announcement bar stays normal */
.announcement-bar {
    position: relative;
    z-index: 10000;
}

/* Main header */
.site-header {
    position: sticky;
    top: 0;
    z-index: 9999;
    background: #ffffff;
    transition: all 0.3s ease;
}

/* Shadow when scrolling */
.site-header.scrolled {
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.12);
}

/* Prevent content hiding under header */
main {
   /* header height */
}

/* Mobile adjustment */
@media (max-width: 768px) {
    main {
       
    }
}

      :root{
        --brand:#d28f63;
        --dark:#2e2724;
      }

      .site-header{background:#fff; border-bottom:1px solid rgba(0,0,0,0.04);}
      .nav-link { color:var(--dark) !important; font-weight:600; }

      .profile-avatar{
        width:42px;
        height:42px;
        border-radius:50%;
        object-fit:cover;
      }
    </style>
    

    <style>
        .announcement-bar {
    background: #4b3f39; /* same as screenshot color */
    font-size: 14px;
    letter-spacing: 0.3px;
}
.announcement-bar a:hover {
    text-decoration: underline;
}

/* MOBILE MENU BUTTON */
.mobile-menu-btn {
    width: 42px;
    height: 42px;
    border-radius: 50%;
    border: 1px solid #ddd;
    background: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    cursor: pointer;
}

.mobile-menu-btn:hover {
    background: #f6f6f6;
}

/* MOBILE TOOLS */
.mobile-tools {
    display: flex;
    align-items: center;
    justify-content: flex-start;
    gap: 8px;
    padding: 10px 0;
    border-top: 1px solid #eee;
    margin-top: 10px;
}

.mobile-tools .search-toggle,
.mobile-tools .fav-icon,
.mobile-tools .user-icon {
    margin: 0 5px;
}

/* Mobile navbar spacing polish */
@media (max-width: 991px) {
    #mobileNav .navbar-artworks .d-flex {
        justify-content: flex-start !important;
        gap: 6px;
    }

    #mobileNav .navbar-artworks .nav-link {
        width: auto;
        display: inline-block !important;
        margin: 0;
        padding-right: 4px !important;
    }

    #mobileNav .currency-select {
        width: 170px;
        min-width: 170px;
        height: 36px;
        border-radius: 20px;
        padding: 4px 10px;
        margin: 0 !important;
    }

    .mobile-tools .search-toggle {
        width: 34px;
        height: 34px;
        transition: all 0.2s ease;
    }

    .mobile-tools .search-toggle.active {
        width: 42px;
        height: 42px;
    }
}

/* ===== GLOBAL ALIGNMENT SYSTEM ===== */
:root{
    --desktop-padding: 45px;
    --mobile-padding: 20px;
}

/* HEADER WRAPPER */
.header-inner{
    padding-left: var(--desktop-padding);
    padding-right: var(--desktop-padding);
}

/* HEADER FLEX ROW */
.header-row{
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding-top: 8px;
    padding-bottom: 8px;
}

/* MOBILE */
@media (max-width: 768px){
    .header-inner{
        padding-left: var(--mobile-padding);
        padding-right: var(--mobile-padding);
    }
}


    </style>

    <?php echo $__env->yieldPushContent('head'); ?>
</head>

<body>

    <!-- ANNOUNCEMENT BAR -->
<!-- <div class="announcement-bar text-center text-white py-1">
    ✨ Fast and secure global shipping. Speak to us for festive picks! 
    Contact: 
    <a href="tel:+919650143758" class="text-white fw-bold">+91 9711210854</a> | 
    <a href="tel:+6586154254" class="text-white fw-bold">+91 9711210854</a> ✨
</div> -->


<header class="site-header">
    <div class="header-inner">
        <div class="header-row">


            <!-- LEFT: LOGO -->
            <a href="/" class="d-flex align-items-center">
                <img src="<?php echo e(asset('uploads/art-logo.png')); ?>" style="height:60px;">
            </a>

            <!-- CENTER: NAV (DESKTOP) -->
            <nav class="d-none d-lg-flex align-items-center gap-4">
                <a class="nav-link" href="/">Home</a>
                <a class="nav-link" href="<?php echo e(\App\Models\SeoPage::url('about', '/about')); ?>">About Us</a>
                <a class="nav-link" href="<?php echo e(\App\Models\SeoPage::url('exclusive', '/exhibitions')); ?>">Exclusives</a>
                  <a class="nav-link" href="<?php echo e(\App\Models\SeoPage::url('artists', '/artists')); ?>">Artists</a>
  <div class="navbar-artworks">

    <div class="d-flex align-items-center justify-content-between">
        <!-- TEXT → PAGE REDIRECT -->
        <a class="nav-link d-block"
           href="<?php echo e(\App\Models\SeoPage::url('artworks', '/artworks')); ?>">
            Artworks
        </a>

        <!-- ARROW → TOGGLE ONLY -->
        <i class="fa fa-angle-down ms-2"
           id="artworksIcon"
           style="cursor:pointer"
           onclick="toggleMobileArtworks(event)">
        </i>
    </div>

    <div class="artwork-dropdown ms-3" id="mobileArtworkDropdown">
        <?php $__currentLoopData = $forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('artworks.form', $form->slug)); ?>">
                <?php echo e($form->name); ?>

            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

</div>




              
                <a class="nav-link" href="<?php echo e(\App\Models\SeoPage::url('blog', '/blogs')); ?>">Blog</a>
                <a class="nav-link" href="<?php echo e(\App\Models\SeoPage::url('art_advisory', '/art-advisory')); ?>">Art Advisory</a>
                <a class="nav-link" href="<?php echo e(\App\Models\SeoPage::url('contact', '/contact')); ?>">Contact Us</a>
            </nav>

            <!-- MOBILE MENU BUTTON -->
           <!-- MOBILE MENU BUTTON -->
<button class="mobile-menu-btn d-lg-none" onclick="toggleMobileNav()">
    <i class="fa fa-bars"></i>
</button>


            <!-- RIGHT: TOOLS (DESKTOP ONLY) -->
            <div class="d-none d-lg-flex align-items-center gap-3">

                <!-- SEARCH -->
                <div class="position-relative">
                    <div class="search-toggle" onclick="toggleSearch()">
                        <i class="fa fa-search"></i>
                    </div>
                    <div class="search-box" id="searchBox">
                        <input type="text" id="searchInput" placeholder="Search artworks, artists...">
                        <div class="search-results" id="searchResults"></div>
                    </div>
                </div>

                <!-- CURRENCY -->
                <select class="currency-select" id="currencySelect">
                    <option value="INR">🇮🇳 INR ₹</option>
                    <option value="USD">🇺🇸 USD $</option>
                    <option value="EUR">🇪🇺 EUR €</option>
                    <option value="GBP">🇬🇧 GBP £</option>
                    <!-- <option value="AUD">🇦🇺 AUD $</option>
                    <option value="CAD">🇨🇦 CAD $</option>
                    <option value="SGD">🇸🇬 SGD $</option>
                    <option value="AED">🇦🇪 AED د.إ</option>
                    <option value="JPY">🇯🇵 JPY ¥</option> -->
                </select>

<!-- FAVOURITE ICON COMMENTED OUT -->


<!-- USER MENU COMMENTED OUT -->



            </div>
        </div>

        <!-- MOBILE NAV COLLAPSE -->
        <div class="collapse navbar-collapse d-lg-none" id="mobileNav">
            <nav class="mt-3">
                <a class="nav-link d-block" href="/">Home</a>
                <a class="nav-link d-block" href="<?php echo e(\App\Models\SeoPage::url('about', '/about')); ?>">About Us</a>
                <a class="nav-link d-block" href="<?php echo e(\App\Models\SeoPage::url('exclusive', '/exhibitions')); ?>">Exclusives</a>
                  <a class="nav-link d-block" href="<?php echo e(\App\Models\SeoPage::url('artists', '/artists')); ?>">Artists</a>
            <!-- MOBILE ARTWORKS -->
<div class="navbar-artworks d-lg-none">

    <div class="d-flex align-items-center justify-content-between">
        <!-- TEXT → REDIRECT -->
        <a class="nav-link d-block"
           href="<?php echo e(\App\Models\SeoPage::url('artworks', '/artworks')); ?>">
            Artworks
        </a>

        <!-- ARROW → TOGGLE -->
        <i class="fa fa-angle-down"
           id="mobileArtworksIcon"
           style="cursor:pointer"
           onclick="toggleMobileArtworks(event)">
        </i>
    </div>

    <div class="artwork-dropdown ms-3"
         id="mobileArtworksDropdown">
        <?php $__currentLoopData = $forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('artworks.form', $form->slug)); ?>">
                <?php echo e($form->name); ?>

            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

</div>


              
                <a class="nav-link d-block" href="<?php echo e(\App\Models\SeoPage::url('blog', '/blogs')); ?>">Blog</a>
                <a class="nav-link d-block" href="<?php echo e(\App\Models\SeoPage::url('art_advisory', '/art-advisory')); ?>">Art Advisory</a>
                <a class="nav-link d-block" href="<?php echo e(\App\Models\SeoPage::url('contact', '/contact')); ?>">Contact Us</a>
            </nav>
            <!-- MOBILE TOOLS -->
            <div class="mobile-tools">
                <!-- SEARCH -->
                <div class="position-relative">
                    <div class="search-toggle" onclick="toggleSearch()">
                        <i class="fa fa-search"></i>
                    </div>
                </div>
                <select class="currency-select" id="mobileCurrencySelect">
                    <option value="INR">🇮🇳 INR ₹</option>
                    <option value="USD">🇺🇸 USD $</option>
                    <option value="EUR">🇪🇺 EUR €</option>
                    <option value="GBP">🇬🇧 GBP £</option>
                    <!-- <option value="AUD">🇦🇺 AUD $</option>
                    <option value="CAD">🇨🇦 CAD $</option>
                    <option value="SGD">🇸🇬 SGD $</option>
                    <option value="AED">🇦🇪 AED د.إ</option>
                    <option value="JPY">🇯🇵 JPY ¥</option> -->
                </select>
<!-- FAVOURITE ICON COMMENTED OUT IN MOBILE -->

<!-- USER ICON COMMENTED OUT IN MOBILE -->

            </div>
        </div>
    </div>
</header>

<!-- PROFILE MODAL COMMENTED OUT -->


<!-- LOGIN / REGISTER PARTIALS COMMENTED OUT -->


<script>
function toggleMobileNav() {
    const nav = document.getElementById('mobileNav');
    nav.classList.toggle('show');
}
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const header = document.querySelector(".site-header");

    window.addEventListener("scroll", function () {
        if (window.scrollY > 40) {
            header.classList.add("scrolled");
        } else {
            header.classList.remove("scrolled");
        }
    });
});
</script>
<script>
function toggleSearch() {
    const box = document.getElementById('searchBox');
    const willOpen = box.style.display !== 'block';
    box.style.display = willOpen ? 'block' : 'none';
    document.querySelectorAll('.mobile-tools .search-toggle').forEach(btn => {
        btn.classList.toggle('active', willOpen);
    });
}

// Close search when clicking outside
document.addEventListener('click', function(e) {
    if (!e.target.closest('.search-toggle') && !e.target.closest('.search-box')) {
        document.getElementById('searchBox').style.display = 'none';
        document.querySelectorAll('.mobile-tools .search-toggle').forEach(btn => {
            btn.classList.remove('active');
        });
    }
});

// Toggle user dropdown on click (for mobile and touch) - COMMENTED OUT
// function toggleUserDropdown() {
//     const dropdown = document.getElementById('userDropdown');
//     dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
// }

// Close user dropdown when clicking outside - COMMENTED OUT
// document.addEventListener('click', function(e) {
//     if (!e.target.closest('.user-menu')) {
//         document.getElementById('userDropdown').style.display = 'none';
//     }
// });

// Toggle mobile artworks dropdown
function toggleMobileArtworks(event) {
    event.preventDefault(); // ⛔ sirf arrow ke liye

    const dropdown = document.getElementById('mobileArtworksDropdown');
    const icon = document.getElementById('mobileArtworksIcon');

    if (!dropdown || !icon) return;

    if (dropdown.style.display === 'block') {
        dropdown.style.display = 'none';
        icon.classList.remove('fa-angle-up');
        icon.classList.add('fa-angle-down');
    } else {
        dropdown.style.display = 'block';
        icon.classList.remove('fa-angle-down');
        icon.classList.add('fa-angle-up');
    }
}



// Toggle mobile user dropdown - COMMENTED OUT
// function toggleMobileUserDropdown() {
//     const dropdown = document.getElementById('mobileUserDropdown');
//     dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
// }

// Close mobile user dropdown when clicking outside - COMMENTED OUT
// document.addEventListener('click', function(e) {
//     if (!e.target.closest('.user-menu')) {
//         document.getElementById('mobileUserDropdown').style.display = 'none';
//     }
// });

// Currency Selection Functionality with Price Update
document.addEventListener('DOMContentLoaded', function() {
    const currencySelect = document.getElementById('currencySelect');
    const mobileCurrencySelect = document.getElementById('mobileCurrencySelect');

    // Exchange rates relative to INR (approximate, update as needed)
    const exchangeRates = {
        INR: 1,
        USD: 0.012, // 1 INR = 0.012 USD approx
        EUR: 0.011, // 1 INR = 0.011 EUR approx
        GBP: 0.0095, // 1 INR = 0.0095 GBP approx
        AUD: 0.018, // 1 INR = 0.018 AUD approx
        CAD: 0.016, // 1 INR = 0.016 CAD approx
        SGD: 0.016, // 1 INR = 0.016 SGD approx
        AED: 0.044, // 1 INR = 0.044 AED approx
        JPY: 1.8 // 1 INR = 1.8 JPY approx
    };

    // Currency symbols
    const currencySymbols = {
        INR: '₹',
        USD: '$',
        EUR: '€',
        GBP: '£',
        AUD: '$',
        CAD: '$',
        SGD: '$',
        AED: 'د.إ',
        JPY: '¥'
    };

    // Function to set currency in localStorage and update display
    function setCurrency(currency) {
        localStorage.setItem('selectedCurrency', currency);
        updatePrices(currency);
        console.log('Currency set to:', currency);
    }

    // Function to update all price elements
    function updatePrices(currency) {
        const rate = exchangeRates[currency];
        const symbol = currencySymbols[currency];
        document.querySelectorAll('.price').forEach(el => {
            const originalPrice = parseFloat(el.getAttribute('data-original-price') || el.textContent.replace(/[^\d.]/g, ''));
            if (!isNaN(originalPrice)) {
                const convertedPrice = (originalPrice * rate).toFixed(2);
                el.textContent = symbol + convertedPrice;
                el.setAttribute('data-original-price', originalPrice); // Store original for future conversions
            }
        });
    }

    // Load saved currency on page load
    const savedCurrency = localStorage.getItem('selectedCurrency') || 'INR';
    currencySelect.value = savedCurrency;
    mobileCurrencySelect.value = savedCurrency;
    updatePrices(savedCurrency); // Update prices on load

    // Event listeners for currency change
    currencySelect.addEventListener('change', function() {
        setCurrency(this.value);
        mobileCurrencySelect.value = this.value; // Sync mobile select
    });

    mobileCurrencySelect.addEventListener('change', function() {
        setCurrency(this.value);
        currencySelect.value = this.value; // Sync desktop select
    });
});

// Search Functionality
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const searchResults = document.getElementById('searchResults');

    // Sample data - Replace with actual API call or data from your backend
    const artworks = [
        { name: 'Painting 1', slug: 'painting-1', type: 'artwork' },
        { name: 'Artist 1', slug: 'artist-1', type: 'artist' },
        // Add more artworks and artists here
    ];

    function performSearch(query) {
        if (query.length < 2) {
            searchResults.innerHTML = '';
            return;
        }

        const filtered = artworks.filter(item =>
            item.name.toLowerCase().includes(query.toLowerCase())
        );

        if (filtered.length === 0) {
            searchResults.innerHTML = '<div class="search-result-item">No results found</div>';
            return;
        }

        const resultsHtml = filtered.map(item => `
            <div class="search-result-item">
                <a href="/${item.type === 'artwork' ? 'artworks' : 'artists'}/${item.slug}">
                    ${item.name} (${item.type})
                </a>
            </div>
        `).join('');

        searchResults.innerHTML = resultsHtml;
    }

    searchInput.addEventListener('input', function() {
        performSearch(this.value);
    });

    // Clear results when search box is closed
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.search-box')) {
            searchResults.innerHTML = '';
        }
    });
});
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>


<?php /**PATH C:\xampp\htdocs\gallery\resources\views/layouts/header.blade.php ENDPATH**/ ?>